package commands

import (
    "fmt"
    "strconv"

    "github.com/fatih/color"
    "github.com/spf13/cobra"
)

func completeCmd() *cobra.Command {
    return &cobra.Command{
        Use:   "complete [task ID]",
        Short: "Mark a task as completed",
        Args:  cobra.ExactArgs(1),
        Example: `  taskmaster complete 42`,
        RunE: func(cmd *cobra.Command, args []string) error {
            id, err := strconv.ParseUint(args[0], 10, 32)
            if err != nil {
                return fmt.Errorf("invalid task ID: %s", args[0])
            }

            if err := taskService.CompleteTask(uint(id)); err != nil {
                return fmt.Errorf("failed to complete task: %w", err)
            }

            color.Green("✓ Task marked as completed!")
            return nil
        },
    }
}
