package commands

import (
    "fmt"
    "strconv"

    "github.com/fatih/color"
    "github.com/spf13/cobra"
)

func deleteCmd() *cobra.Command {
    return &cobra.Command{
        Use:   "delete [task ID]",
        Short: "Delete a task",
        Args:  cobra.ExactArgs(1),
        Example: `  taskmaster delete 42`,
        RunE: func(cmd *cobra.Command, args []string) error {
            id, err := strconv.ParseUint(args[0], 10, 32)
            if err != nil {
                return fmt.Errorf("invalid task ID: %s", args[0])
            }

            if err := taskService.DeleteTask(uint(id)); err != nil {
                return fmt.Errorf("failed to delete task: %w", err)
            }

            color.Red("✓ Task deleted.")
            return nil
        },
    }
}
