package commands

import (
    "github.com/spf13/cobra"
    "github.com/yourusername/taskmaster/internal/service"
)

var taskService service.TaskService

func Execute(svc service.TaskService) error {
    taskService = svc

    rootCmd := &cobra.Command{
        Use:   "taskmaster",
        Short: "A powerful CLI task management tool",
        Long: `TaskMaster helps you manage your tasks efficiently from the command line.

Features:
  - Create, list, update, and delete tasks
  - Filter by status, priority, and tags
  - Search across task titles and descriptions
  - Track task completion with statistics`,
    }

    // Add subcommands
    rootCmd.AddCommand(addCmd())
    rootCmd.AddCommand(listCmd())
    rootCmd.AddCommand(completeCmd())
    rootCmd.AddCommand(deleteCmd())
    rootCmd.AddCommand(updateCmd())
    rootCmd.AddCommand(statsCmd())

    return rootCmd.Execute()
}
