package commands

import (
    "fmt"

    "github.com/fatih/color"
    "github.com/spf13/cobra"
)

func statsCmd() *cobra.Command {
    return &cobra.Command{
        Use:   "stats",
        Short: "Display task statistics",
        RunE: func(cmd *cobra.Command, args []string) error {
            stats, err := taskService.GetStatistics()
            if err != nil {
                return fmt.Errorf("failed to get statistics: %w", err)
            }

            fmt.Println("Task Statistics")
            fmt.Println("===============")
            fmt.Printf("Total Tasks:     %d\n", stats.Total)

            // Calculate completion rate
            if stats.Total > 0 {
                rate := float64(stats.Completed) / float64(stats.Total) * 100
                color.Green("Completed:       %d (%.1f%%)", stats.Completed, rate)
            } else {
                fmt.Printf("Completed:       %d\n", stats.Completed)
            }

            fmt.Printf("Pending:         %d\n", stats.Pending)
            fmt.Printf("In Progress:     %d\n", stats.InProgress)
            fmt.Printf("Cancelled:       %d\n", stats.Cancelled)

            return nil
        },
    }
}
