package models

import (
	"time"
	"go.mongodb.org/mongo-driver/bson/primitive"
)

type Room struct {
	ID          primitive.ObjectID   `bson:"_id,omitempty" json:"id"`
	Name        string               `bson:"name" json:"name"`
	Description string               `bson:"description" json:"description"`
	CreatorID   primitive.ObjectID   `bson:"creator_id" json:"creator_id"`
	Members     []primitive.ObjectID `bson:"members" json:"members"`
	IsPrivate   bool                 `bson:"is_private" json:"is_private"`
	CreatedAt   time.Time            `bson:"created_at" json:"created_at"`
	UpdatedAt   time.Time            `bson:"updated_at" json:"updated_at"`
}
