package pubsub

import (
	"context"

	"github.com/redis/go-redis/v9"
)

type RedisPubSub struct {
	client *redis.Client
	ctx    context.Context
}

func New(addr string) *RedisPubSub {
	client := redis.NewClient(&redis.Options{
		Addr: addr,
	})

	return &RedisPubSub{
		client: client,
		ctx:    context.Background(),
	}
}

func (r *RedisPubSub) Publish(channel, message string) error {
	return r.client.Publish(r.ctx, channel, message).Err()
}

func (r *RedisPubSub) Subscribe(channel string, handler func(string)) {
	pubsub := r.client.Subscribe(r.ctx, channel)
	defer pubsub.Close()

	ch := pubsub.Channel()

	go func() {
		for msg := range ch {
			handler(msg.Payload)
		}
	}()
}

func (r *RedisPubSub) Close() error {
	return r.client.Close()
}
