package service

import (
	"github.com/yourusername/restapi/internal/models"
	"github.com/yourusername/restapi/internal/repository"
)

type UserService interface {
	GetByID(id int64) (*models.User, error)
	List() ([]*models.User, error)
	Update(user *models.User) error
	Delete(id int64) error
}

type userService struct {
	userRepo repository.UserRepository
}

func NewUserService(userRepo repository.UserRepository) UserService {
	return &userService{userRepo: userRepo}
}

func (s *userService) GetByID(id int64) (*models.User, error) {
	return s.userRepo.GetByID(id)
}

func (s *userService) List() ([]*models.User, error) {
	return s.userRepo.List()
}

func (s *userService) Update(user *models.User) error {
	return s.userRepo.Update(user)
}

func (s *userService) Delete(id int64) error {
	return s.userRepo.Delete(id)
}
