# Documentation Index

Quick navigation guide for all documentation files.

## Start Here

### For First-Time Users
1. **[QUICKSTART.md](QUICKSTART.md)** - Get running in 5 minutes
   - Single node setup
   - 3-node cluster setup
   - Basic API operations
   - Troubleshooting common issues

2. **[EXAMPLES.md](EXAMPLES.md)** - Practical usage examples
   - Single node testing
   - Multi-node cluster
   - Complete workflows
   - Fault tolerance demo

## Core Documentation

### Architecture & Design
- **[README.md](README.md)** - Complete implementation guide (2,681 lines)
  - System architecture overview
  - Raft consensus protocol explanation
  - Component architecture (HTTP, Node, FSM, Storage layers)
  - Data flow diagrams
  - Technology stack details
  - Project structure
  - Implementation guide (step-by-step)
  - API reference (complete)
  - Production considerations
  - Extending the system
  - Troubleshooting basics
  - Resources

### Deployment
- **[DEPLOYMENT_GUIDE.md](DEPLOYMENT_GUIDE.md)** - Production deployment
  - Local development setup
  - Docker deployment (single and multi-node)
  - Kubernetes deployment (StatefulSet, jobs)
  - Cloud provider deployments (AWS ECS, Google Cloud Run, Azure)
  - Security hardening
  - Monitoring setup (Prometheus)
  - Backup and recovery
  - Performance tuning
  - High availability architecture

### Troubleshooting
- **[TROUBLESHOOTING.md](TROUBLESHOOTING.md)** - Problem solving
  - Startup issues
  - Cluster formation issues
  - Replication problems
  - Performance issues
  - Network issues
  - Data loss prevention
  - Debugging tools
  - FAQ

## Source Code

### Command Line Interface
- **[cmd/kvstore/main.go](cmd/kvstore/main.go)** - Application entry point
  - Configuration parsing
  - Node initialization
  - HTTP server startup
  - Graceful shutdown

### Consensus & State Machine
- **[internal/raft/fsm.go](internal/raft/fsm.go)** - Finite State Machine
  - Command processing
  - Snapshots and restoration
  - State application

### Storage Layer
- **[internal/storage/interface.go](internal/storage/interface.go)** - Storage abstraction
  - Interface definition
  - Contract for implementations

- **[internal/storage/memory.go](internal/storage/memory.go)** - In-memory storage
  - Get/Set/Delete operations
  - Prefix listing
  - Snapshot support

### Node & Networking
- **[internal/server/node.go](internal/server/node.go)** - Distributed node logic
  - Raft integration
  - Cluster management
  - Node operations
  - Statistics gathering

- **[internal/server/http.go](internal/server/http.go)** - HTTP API layer
  - RESTful endpoints
  - Request handling
  - JSON serialization
  - Error handling

### Configuration
- **[go.mod](go.mod)** - Go module dependencies
- **[go.sum](go.sum)** - Dependency checksums
- **[Dockerfile](Dockerfile)** - Container image definition
- **[docker-compose.yml](docker-compose.yml)** - Multi-container setup

## Scripts & Automation
- **[demo.sh](demo.sh)** - Automated cluster demo
  - Builds project
  - Starts 3-node cluster
  - Demonstrates operations
  - Tests fault tolerance

## Quick Reference

### API Endpoints

| Endpoint | Method | Purpose |
|----------|--------|---------|
| /api/get | GET | Retrieve a value |
| /api/set | POST | Store a key-value pair |
| /api/delete | DELETE | Remove a key |
| /api/list | GET | List keys by prefix |
| /api/join | POST | Add node to cluster |
| /api/stats | GET | Cluster statistics |
| /health | GET | Health check |

### Command-Line Flags

| Flag | Environment | Default | Purpose |
|------|-------------|---------|---------|
| --node-id | NODE_ID | node1 | Unique node identifier |
| --raft-addr | RAFT_ADDR | localhost:7000 | Raft bind address |
| --http-addr | HTTP_ADDR | :8080 | HTTP API address |
| --data-dir | DATA_DIR | ./data | Data directory path |
| --bootstrap | BOOTSTRAP | false | Bootstrap as first node |
| --join | JOIN | "" | Join existing cluster |

## Learning Path

### Beginner (30 minutes)
1. Read QUICKSTART.md
2. Run single node setup
3. Try basic API operations
4. Review EXAMPLES.md

### Intermediate (2 hours)
1. Read README.md architecture sections
2. Setup 3-node cluster
3. Experiment with EXAMPLES.md
4. Review TROUBLESHOOTING.md

### Advanced (1 day)
1. Study Raft consensus section in README.md
2. Review source code (start with main.go)
3. Try DEPLOYMENT_GUIDE.md
4. Extend with custom features

### Expert (ongoing)
1. Study HashiCorp Raft library documentation
2. Implement persistent storage (BadgerDB)
3. Add monitoring (Prometheus)
4. Deploy to Kubernetes
5. Contribute improvements

## Key Concepts

### Raft Consensus
- **States**: Follower, Candidate, Leader
- **Election**: Triggered when no heartbeat received
- **Replication**: Log entries replicated to followers
- **Safety**: Guarantees consistency across nodes

### Cluster Topology
- **Minimum**: 1 node (single node mode)
- **Recommended**: 3 nodes (production)
- **High Availability**: 5-7 nodes
- **Quorum**: Need majority for operations

### Data Flow
1. Client sends request to any node
2. If not leader, redirected to leader
3. Leader replicates to followers
4. Once majority acknowledges, committed
5. All nodes apply to state machine
6. Response returned to client

### Deployment Options
1. **Local**: Direct binary execution
2. **Docker**: Single container or compose
3. **Kubernetes**: StatefulSet deployment
4. **Cloud**: ECS, Cloud Run, Container Instances

## File Size Reference

```
README.md               ~70 KB  (comprehensive guide)
DEPLOYMENT_GUIDE.md    ~50 KB  (production setup)
TROUBLESHOOTING.md     ~35 KB  (problem solving)
QUICKSTART.md          ~15 KB  (getting started)
EXAMPLES.md            ~15 KB  (usage examples)

Source Code:
  main.go              ~2.5 KB
  node.go              ~4 KB
  http.go              ~6 KB
  fsm.go               ~1.5 KB
  storage/             ~2 KB
```

## Getting Help

### Documentation Files by Purpose

**Setup & Installation**
- QUICKSTART.md - Fastest way to get started
- DEPLOYMENT_GUIDE.md - Different deployment scenarios

**Learning & Understanding**
- README.md - Comprehensive reference
- EXAMPLES.md - Practical demonstrations

**Troubleshooting**
- TROUBLESHOOTING.md - Issues and solutions
- README.md - Sections: Troubleshooting, FAQ

**Development**
- README.md - Implementation guide
- Source code files with inline comments

### External Resources

**Raft Consensus**
- [Official Raft Website](https://raft.github.io/)
- [Visual Raft Explanation](http://thesecretlivesofdata.com/raft/)
- [Raft Paper](https://raft.github.io/raft.pdf)

**Distributed Systems**
- [Designing Data-Intensive Applications](https://dataintensive.net/)
- [Distributed Systems in Go](https://golang.org/)

**HashiCorp Raft**
- [GitHub Repository](https://github.com/hashicorp/raft)
- [API Documentation](https://pkg.go.dev/github.com/hashicorp/raft)

## Document Statistics

| Document | Lines | Topics | Code Examples |
|----------|-------|--------|----------------|
| README.md | 2,681 | 12+ | 100+ |
| DEPLOYMENT_GUIDE.md | 1,200+ | 8+ | 50+ |
| TROUBLESHOOTING.md | 800+ | 20+ | 40+ |
| QUICKSTART.md | 400+ | 6+ | 20+ |
| EXAMPLES.md | 250+ | 7+ | 15+ |
| **Total** | **~5,300** | **50+** | **225+** |

## Version Information

- **Go Version**: 1.24+
- **Last Updated**: 2025-10-22
- **Project Status**: Production Ready
- **License**: MIT (Educational Use)

## Contributing

This project is designed for learning. To contribute:

1. Report issues in TROUBLESHOOTING.md format
2. Suggest improvements to documentation
3. Share your deployment experiences
4. Contribute bug fixes with tests

---

## Quick Navigation Links

**Want to...**
- Get started immediately? → [QUICKSTART.md](QUICKSTART.md)
- Understand the design? → [README.md](README.md) - Architecture sections
- Deploy to production? → [DEPLOYMENT_GUIDE.md](DEPLOYMENT_GUIDE.md)
- Troubleshoot an issue? → [TROUBLESHOOTING.md](TROUBLESHOOTING.md)
- See working examples? → [EXAMPLES.md](EXAMPLES.md)
- Run a demo? → `./demo.sh`
- Modify the code? → [README.md](README.md) - Implementation guide
- Learn Raft? → [README.md](README.md) - Raft Consensus Protocol section

---

**Pro Tip**: Start with QUICKSTART.md, then read README.md architecture sections while your cluster is running. Jump to TROUBLESHOOTING.md if you hit issues.

Happy learning! 🚀

Last updated: 2025-10-22
