package storage

import "io"

// Storage defines the interface for key-value storage operations
type Storage interface {
	Get(key string) (string, error)
	Set(key, value string) error
	Delete(key string) error
	List(prefix string) (map[string]string, error)
	Snapshot(w io.Writer) error
	Restore(r io.Reader) error
	Close() error
}
