#!/bin/bash

# Sample script to query metrics from the observability platform

BASE_URL="${BASE_URL:-http://localhost:8080}"

echo "Querying metrics..."

curl -X POST "$BASE_URL/api/metrics/query" \
  -H "Content-Type: application/json" \
  -d '{
    "metric": "http_requests_total",
    "labels": {
      "service": "api"
    },
    "start_time": "2024-01-01T00:00:00Z",
    "end_time": "2025-12-31T23:59:59Z",
    "step": "60s"
  }' | python3 -m json.tool 2>/dev/null || cat

echo ""
