#!/bin/bash

# Sample script to ingest logs into the observability platform

BASE_URL="${BASE_URL:-http://localhost:8080}"

echo "Ingesting sample logs..."

# Sample error log
curl -X POST "$BASE_URL/api/logs/ingest" \
  -H "Content-Type: application/json" \
  -d '{
    "level": "error",
    "service": "checkout",
    "message": "Payment processing failed",
    "fields": {
      "order_id": "12345",
      "amount": 99.99,
      "error": "card_declined"
    }
  }'

echo ""

# Sample info log
curl -X POST "$BASE_URL/api/logs/ingest" \
  -H "Content-Type: application/json" \
  -d '{
    "level": "info",
    "service": "auth",
    "message": "User login successful",
    "fields": {
      "user_id": "user123",
      "ip": "192.168.1.100"
    }
  }'

echo ""

# Sample warning log
curl -X POST "$BASE_URL/api/logs/ingest" \
  -H "Content-Type: application/json" \
  -d '{
    "level": "warn",
    "service": "inventory",
    "message": "Low stock alert",
    "fields": {
      "product_id": "prod456",
      "quantity": 5
    }
  }'

echo ""
echo "Sample logs ingested successfully!"

# Query the logs
echo ""
echo "Querying logs..."
curl -X POST "$BASE_URL/api/logs/query" \
  -H "Content-Type: application/json" \
  -d '{
    "start_time": "2024-01-01T00:00:00Z",
    "end_time": "2025-12-31T23:59:59Z",
    "limit": 100
  }' | python3 -m json.tool 2>/dev/null || cat

echo ""
