package benchmarks

import (
	"fmt"
	"testing"

	"github.com/distributed-db/pkg/storage"
)

func BenchmarkLSMWrite(b *testing.B) {
	config := storage.DefaultLSMConfig()
	config.DataDir = "/tmp/bench-lsm-write"
	lsm, err := storage.NewLSMTree(config)
	if err != nil {
		b.Fatal(err)
	}
	defer lsm.Close()

	b.ResetTimer()

	for i := 0; i < b.N; i++ {
		key := []byte(fmt.Sprintf("key%010d", i))
		value := []byte(fmt.Sprintf("value%010d", i))
		lsm.Put(key, value)
	}

	b.ReportMetric(float64(b.N)/b.Elapsed().Seconds(), "ops/sec")
}

func BenchmarkLSMRead(b *testing.B) {
	config := storage.DefaultLSMConfig()
	config.DataDir = "/tmp/bench-lsm-read"
	lsm, err := storage.NewLSMTree(config)
	if err != nil {
		b.Fatal(err)
	}
	defer lsm.Close()

	// Pre-populate data
	for i := 0; i < 100000; i++ {
		key := []byte(fmt.Sprintf("key%010d", i))
		value := []byte(fmt.Sprintf("value%010d", i))
		lsm.Put(key, value)
	}

	b.ResetTimer()

	for i := 0; i < b.N; i++ {
		key := []byte(fmt.Sprintf("key%010d", i%100000))
		lsm.Get(key)
	}

	b.ReportMetric(float64(b.N)/b.Elapsed().Seconds(), "ops/sec")
}
