-- Basic Examples for Distributed Database

-- Note: This is a key-value database, so SQL is not fully implemented
-- These examples show the intended SQL interface

-- Create a table (future feature)
CREATE TABLE users (
  id SERIAL PRIMARY KEY,
  email VARCHAR(255) UNIQUE NOT NULL,
  name VARCHAR(255),
  created_at TIMESTAMP DEFAULT NOW()
);

-- Insert data
INSERT INTO users (email, name) VALUES ('alice@example.com', 'Alice');
INSERT INTO users (email, name) VALUES ('bob@example.com', 'Bob');

-- Query data
SELECT * FROM users WHERE email = 'alice@example.com';

-- Update data
UPDATE users SET name = 'Alice Smith' WHERE email = 'alice@example.com';

-- Delete data
DELETE FROM users WHERE email = 'bob@example.com';

-- Current key-value interface (what's actually implemented):
-- SET user:1:email "alice@example.com"
-- GET user:1:email
-- DELETE user:1:email
-- SCAN user: user:z
