-- Distributed Transaction Examples

-- Example 1: Money Transfer (ACID transaction across shards)
BEGIN;
  -- Deduct from account 1 (shard A)
  UPDATE accounts SET balance = balance - 100 WHERE account_id = 1;

  -- Add to account 2 (shard B)
  UPDATE accounts SET balance = balance + 100 WHERE account_id = 2;
COMMIT;

-- Example 2: E-commerce Order (multi-shard transaction)
BEGIN;
  -- Deduct inventory (shard A)
  UPDATE inventory SET quantity = quantity - 1 WHERE product_id = 'laptop-123';

  -- Create order (shard B)
  INSERT INTO orders (user_id, product_id, amount) VALUES (999, 'laptop-123', 1299.00);

  -- Charge payment (shard C)
  INSERT INTO payments (order_id, amount, status) VALUES (LAST_INSERT_ID(), 1299.00, 'pending');
COMMIT;

-- Example 3: Rollback on Failure
BEGIN;
  UPDATE accounts SET balance = balance - 500 WHERE account_id = 1;
  UPDATE accounts SET balance = balance + 500 WHERE account_id = 2;
  -- If any operation fails, entire transaction is rolled back
ROLLBACK;

-- Current key-value interface with transactions:
-- BEGIN
-- SET account:1:balance "900"
-- SET account:2:balance "1100"
-- COMMIT
