package sharding

import (
	"bytes"
	"hash/fnv"
)

// Router determines which shard a key belongs to
type Router struct {
	ranges []Range
}

// Range represents a shard range
type Range struct {
	Start    []byte
	End      []byte
	ShardID  int
	Replicas []string
}

// NewRouter creates a new router
func NewRouter(ranges []Range) *Router {
	return &Router{
		ranges: ranges,
	}
}

// GetShard returns the shard ID for a key
func (r *Router) GetShard(key []byte) int {
	// Range-based sharding
	for _, rng := range r.ranges {
		if bytes.Compare(key, rng.Start) >= 0 && bytes.Compare(key, rng.End) < 0 {
			return rng.ShardID
		}
	}

	// Fallback to hash-based sharding
	h := fnv.New32a()
	h.Write(key)
	return int(h.Sum32()) % len(r.ranges)
}
