package main

import (
	"fmt"
	"go/format"
)

// FormatPlugin provides Go code formatting functionality
type FormatPlugin struct {
	name    string
	version string
}

// NewFormatPlugin creates a new formatter plugin
func NewFormatPlugin() *FormatPlugin {
	return &FormatPlugin{
		name:    "go-formatter",
		version: "1.0.0",
	}
}

// Name returns the plugin name
func (p *FormatPlugin) Name() string {
	return p.name
}

// Version returns the plugin version
func (p *FormatPlugin) Version() string {
	return p.version
}

// Description returns plugin description
func (p *FormatPlugin) Description() string {
	return "Formats Go code using gofmt"
}

// Format formats Go source code
func (p *FormatPlugin) Format(source []byte) ([]byte, error) {
	formatted, err := format.Source(source)
	if err != nil {
		return nil, fmt.Errorf("format error: %w", err)
	}
	return formatted, nil
}

// Activate is called when the plugin is loaded
func (p *FormatPlugin) Activate() error {
	fmt.Println("Go formatter plugin activated")
	return nil
}

// Deactivate is called when the plugin is unloaded
func (p *FormatPlugin) Deactivate() error {
	fmt.Println("Go formatter plugin deactivated")
	return nil
}

// Example usage:
// plugin := NewFormatPlugin()
// formatted, err := plugin.Format([]byte("package main\nfunc main(){fmt.Println(\"hello\")}"))
