# Simple Token Contract
#
# Storage Layout:
# 0: total_supply
# 1 + address: balance[address]
#
# Functions:
# - balanceOf(address) -> uint
# - transfer(to, amount) -> bool

# balanceOf function
PUSH 1          # Storage key offset
CALLER          # Get caller address (converted to uint64)
ADD             # key = 1 + caller
SLOAD           # Load balance from storage
RETURN          # Return balance

# transfer function (simplified)
# Assume: recipient address in storage key 2, amount in CALLVALUE

# Check sender has sufficient balance
PUSH 1
CALLER
ADD
SLOAD           # sender_balance
CALLVALUE       # amount
LT              # sender_balance < amount?
JUMPI 100       # If true, jump to REVERT

# Deduct from sender
PUSH 1
CALLER
ADD
DUP
SLOAD
CALLVALUE
SUB
SSTORE

# Add to recipient (assume recipient at key 2)
PUSH 2
DUP
SLOAD
CALLVALUE
ADD
SSTORE

PUSH 1          # Return success (1)
RETURN

# REVERT label (position 100)
PUSH 0          # Return failure (0)
RETURN
