package blockchain

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestNewBlockchain(t *testing.T) {
	bc := NewBlockchain()

	assert.NotNil(t, bc)
	assert.Equal(t, uint64(0), bc.GetHeight())

	genesis := bc.GetLatestBlock()
	assert.NotNil(t, genesis)
	assert.Equal(t, uint64(0), genesis.Header.Height)
}

func TestMerkleTree(t *testing.T) {
	tx1 := &Transaction{
		From:  "0xabc",
		To:    "0xdef",
		Value: 100,
	}
	tx1.Hash = tx1.CalculateHash()

	tx2 := &Transaction{
		From:  "0x123",
		To:    "0x456",
		Value: 200,
	}
	tx2.Hash = tx2.CalculateHash()

	txs := []*Transaction{tx1, tx2}
	root := CalculateMerkleRoot(txs)

	assert.NotNil(t, root)
	assert.Equal(t, 32, len(root))
}

func TestTransactionHash(t *testing.T) {
	tx := &Transaction{
		From:  "0xabc",
		To:    "0xdef",
		Value: 100,
		Nonce: 1,
	}

	hash1 := tx.CalculateHash()
	hash2 := tx.CalculateHash()

	assert.Equal(t, hash1, hash2)
	assert.Equal(t, 32, len(hash1))
}
