package wallet

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestNewWallet(t *testing.T) {
	w, err := NewWallet()
	require.NoError(t, err)

	assert.NotNil(t, w.PrivateKey)
	assert.NotNil(t, w.PublicKey)
	assert.NotEmpty(t, w.Address)
	assert.Contains(t, w.Address, "0x")
}

func TestCreateTransaction(t *testing.T) {
	w, err := NewWallet()
	require.NoError(t, err)

	tx, err := w.CreateTransaction("0xrecipient", 100, nil, 1)
	require.NoError(t, err)

	assert.Equal(t, w.Address, tx.From)
	assert.Equal(t, "0xrecipient", tx.To)
	assert.Equal(t, uint64(100), tx.Value)
	assert.NotEmpty(t, tx.Signature)
	assert.NotEmpty(t, tx.Hash)
}

func TestTransactionSignature(t *testing.T) {
	w, err := NewWallet()
	require.NoError(t, err)

	tx, err := w.CreateTransaction("0xrecipient", 100, nil, 1)
	require.NoError(t, err)

	// Verify signature with public key
	isValid := tx.Verify(w.PublicKey)
	assert.True(t, isValid)
}
