package cli

import (
	"fmt"
	"time"

	"github.com/fatih/color"
	"taskmaster/internal/models"
	"taskmaster/internal/storage"
)

// AddTask handles the 'add' command
func AddTask(store storage.Storage, title, description string, priority models.Priority) error {
	task := &models.Task{
		Title:       title,
		Description: description,
		Priority:    priority,
		Completed:   false,
		CreatedAt:   time.Now(),
	}

	if err := store.CreateTask(task); err != nil {
		return fmt.Errorf("failed to add task: %w", err)
	}

	green := color.New(color.FgGreen, color.Bold)
	green.Printf("✓ Task added successfully!\n")
	fmt.Printf("  ID: %d\n", task.ID)
	fmt.Printf("  Title: %s\n", task.Title)
	fmt.Printf("  Priority: %s\n", task.Priority)

	if task.Description != "" {
		fmt.Printf("  Description: %s\n", task.Description)
	}

	return nil
}
