package cli

import (
	"fmt"

	"github.com/fatih/color"
	"taskmaster/internal/storage"
)

// CompleteTask handles the 'complete' command
func CompleteTask(store storage.Storage, id int) error {
	task, err := store.GetTask(id)
	if err != nil {
		return fmt.Errorf("task not found: %w", err)
	}

	if task.Completed {
		color.Yellow("Task is already completed!")
		return nil
	}

	task.MarkComplete()

	if err := store.UpdateTask(task); err != nil {
		return fmt.Errorf("failed to complete task: %w", err)
	}

	green := color.New(color.FgGreen, color.Bold)
	green.Printf("✓ Task #%d marked as complete!\n", id)
	fmt.Printf("  %s\n", task.Title)

	return nil
}
