package cli

import (
	"fmt"

	"github.com/fatih/color"
	"taskmaster/internal/storage"
)

// DeleteTask handles the 'delete' command
func DeleteTask(store storage.Storage, id int) error {
	// Verify task exists
	task, err := store.GetTask(id)
	if err != nil {
		return fmt.Errorf("task not found: %w", err)
	}

	if err := store.DeleteTask(id); err != nil {
		return fmt.Errorf("failed to delete task: %w", err)
	}

	red := color.New(color.FgRed)
	red.Printf("✗ Task deleted: %s\n", task.Title)

	return nil
}
