package storage

import "taskmaster/internal/models"

// Storage defines the interface for task persistence
type Storage interface {
	// CreateTask adds a new task to storage
	CreateTask(task *models.Task) error

	// GetTask retrieves a task by ID
	GetTask(id int) (*models.Task, error)

	// ListTasks returns all tasks matching the filter
	ListTasks(filter *TaskFilter) ([]*models.Task, error)

	// UpdateTask updates an existing task
	UpdateTask(task *models.Task) error

	// DeleteTask removes a task by ID
	DeleteTask(id int) error

	// Close closes the storage connection
	Close() error
}

// TaskFilter defines filtering criteria
type TaskFilter struct {
	Status   string // "all", "pending", "completed"
	Priority *models.Priority
}
