package extract

import (
	"context"
	"github.com/yourusername/etl-pipeline/pkg/models"
)

// Extractor defines the interface for data extractors
type Extractor interface {
	Extract(ctx context.Context) (<-chan *models.Record, <-chan error)
	Close() error
}

// Options contains common extractor options
type Options struct {
	Schema      *models.Schema
	SkipInvalid bool
	BufferSize  int
}
