package load

import (
	"context"
	"github.com/yourusername/etl-pipeline/pkg/models"
)

// Loader defines the interface for data loaders
type Loader interface {
	Load(ctx context.Context, records <-chan *models.Record) error
	Close() error
}

// Options contains common loader options
type Options struct {
	BatchSize int
	Pretty    bool
}
